(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, italic, e6,  14, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, R65535, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, bold, L-5,  10, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  10, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  10, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, B65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w282, h287,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	paletteColors = 128; automaticGrouping; currentKernel; 
]
:[font = title; inactive; locked; preserveAspect; startGroup]
Quantum Teleportation
:[font = subsubtitle; inactive; locked; preserveAspect]
Colin P. Williams
:[font = postscript; PostScript; formatAsPostScript; output; inactive; locked; preserveAspect; pictureLeft = 34; pictureWidth = 340; pictureHeight = 104]
%!
%%Creator: Mathematica
%%AspectRatio: .30693 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.049505 0.0990099 0.0693069 0.0990099 [
[ 0 0 0 0 ]
[ 1 .30693 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
P
0 0 m
1 0 L
1 .30693 L
0 .30693 L
closepath
clip
newpath
p
p
1 Mabswid
.07426 .14356 m
.07426 .19307 L
.12376 .19307 L
.12376 .14356 L
.07426 .14356 L
s
p
/Courier findfont 12 scalefont setfont
[(L)] .09901 .16832 0 0 Mshowa
P
.0495 .16832 m
.07426 .16832 L
s
.12376 .16832 m
.14851 .16832 L
s
newpath
.19802 .06931 .0198 0 365.73 arc
s
6 Mabswid
.19802 .16832 Mdot
1 Mabswid
.19802 .0495 m
.19802 .16832 L
s
.14851 .06931 m
.24752 .06931 L
s
.14851 .16832 m
.24752 .16832 L
s
.0495 .06931 m
.14851 .06931 L
s
P
p
1 Mabswid
newpath
.29703 .16832 .0198 0 365.73 arc
s
6 Mabswid
.29703 .26733 Mdot
1 Mabswid
.29703 .14851 m
.29703 .26733 L
s
.24752 .16832 m
.34653 .16832 L
s
.24752 .26733 m
.34653 .26733 L
s
.37129 .24257 m
.37129 .29208 L
.42079 .29208 L
.42079 .24257 L
.37129 .24257 L
s
p
/Courier findfont 12 scalefont setfont
[(R)] .39604 .26733 0 0 Mshowa
P
.34653 .26733 m
.37129 .26733 L
s
.42079 .26733 m
.44554 .26733 L
s
.34653 .16832 m
.44554 .16832 L
s
P
p
p
/Symbol findfont 10 scalefont setfont
[(|y>)] 0 .26733 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(|0>)] 0 .06931 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(|0>)] 0 .16832 -1 0 Mshowa
P
P
p
p
/Symbol findfont 10 scalefont setfont
[(r)] .45545 .08911 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(s)] .24752 .18812 0 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(?)] .45545 .16832 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(?)] .45545 .26733 -1 0 Mshowa
P
1 Mabswid
.24752 .06931 m
.54455 .06931 L
s
.0495 .26733 m
.24752 .26733 L
s
P
p
1 Mabswid
newpath
.59406 .06931 .0198 0 365.73 arc
s
6 Mabswid
.59406 .16832 Mdot
1 Mabswid
.59406 .0495 m
.59406 .16832 L
s
.54455 .06931 m
.64356 .06931 L
s
.54455 .16832 m
.64356 .16832 L
s
.56931 .24257 m
.56931 .29208 L
.61881 .29208 L
.61881 .24257 L
.56931 .24257 L
s
p
/Courier findfont 12 scalefont setfont
[(S)] .59406 .26733 0 0 Mshowa
P
.54455 .26733 m
.56931 .26733 L
s
.61881 .26733 m
.64356 .26733 L
s
newpath
.69307 .26733 .0198 0 365.73 arc
s
6 Mabswid
.69307 .06931 Mdot
1 Mabswid
.69307 .28713 m
.69307 .06931 L
s
.64356 .26733 m
.74257 .26733 L
s
.64356 .06931 m
.74257 .06931 L
s
.76733 .24257 m
.76733 .29208 L
.81683 .29208 L
.81683 .24257 L
.76733 .24257 L
s
p
/Courier findfont 12 scalefont setfont
[(S)] .79208 .26733 0 0 Mshowa
P
.74257 .26733 m
.76733 .26733 L
s
.81683 .26733 m
.84158 .26733 L
s
.76733 .04455 m
.76733 .09406 L
.81683 .09406 L
.81683 .04455 L
.76733 .04455 L
s
p
/Courier findfont 12 scalefont setfont
[(T)] .79208 .06931 0 0 Mshowa
P
.74257 .06931 m
.76733 .06931 L
s
.81683 .06931 m
.84158 .06931 L
s
newpath
.89109 .26733 .0198 0 365.73 arc
s
6 Mabswid
.89109 .06931 Mdot
1 Mabswid
.89109 .28713 m
.89109 .06931 L
s
.84158 .26733 m
.94059 .26733 L
s
.84158 .06931 m
.94059 .06931 L
s
.64356 .16832 m
.94059 .16832 L
s
P
p
p
/Symbol findfont 10 scalefont setfont
[(|f>)] .9505 .26733 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(|f>)] .9505 .16832 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(|y>)] .9505 .06931 -1 0 Mshowa
P
P
p
[ .01 .01 ] 0 setdash
1 Mabswid
.06188 .03218 m
.06188 .30446 L
.43317 .30446 L
.43317 .03218 L
.06188 .03218 L
s
[(Alice)] .24752 .0099 0 0 Mshowa
P
p
[ .01 .01 ] 0 setdash
1 Mabswid
.55693 .03218 m
.55693 .30446 L
.92822 .30446 L
.92822 .03218 L
.55693 .03218 L
s
[(Bob)] .74257 .0099 0 0 Mshowa
P
P
% End of Graphics
MathPictureEnd

:[font = input; initialization; preserveAspect]
*)
Off[General::spell1]
(*
:[font = section; inactive; locked; preserveAspect; startGroup]
Copyright Notice
:[font = text; inactive; locked; preserveAspect; endGroup]
Copyright Colin P. Williams (1997).

This Notebook is intended to be used in conjunction with "Explorations in Quantum Computing" by Colin P. Williams and Scott H. Clearwater, TELOS, Springer-Verlag (1997), ISBN:0-387-94768-X. Permission is hereby granted to copy and distribute this Notebook freely for any non-commercial activity provided you include this copyright notice at the beginning of all such copies. Please send suggestions and bug reports to Colin P. Williams at 
        colin@solstice.jpl.nasa.gov      (818) 306 6512 or 
        cpw@cs.stanford.edu               (415) 728 2118
For information on "Explorations in Quantum Computing" check out the TELOS web site:  http://www.telospub.com/catalog/PHYSICS/Explorations.html. To order call 1-800-777-4643.

All other rights reserved.
:[font = section; inactive; locked; preserveAspect; startGroup]
Introduction to Teleportation
:[font = text; inactive; locked; preserveAspect]
This Notebook contains code for simulating quantum teleportation of an arbitrary quantum state from a sender, Alice, to a receiver, Bob (see "Explorations in Quantum Computing", Chapter 9).   Unlike the science fiction accounts of teleportation, the mechanism that we describe is consistent with known physics.  Better yet, the number of operations on qubits that would be required to implement quantum teleportation is far less than the number of operations needed to implement Shor's quantum  algorithm for factoring large composite  integers.  As a result,  an experimental demonstration of quantum teleportation appears to be feasible given in the near future!  The "teleportation circuit", devised by Gilles Brassard, that we describe below is capable of performing all the necessary stages of quantum teleportation.

Prior to Alice attempting to teleport a quantum state to Bob, Alice and Bob must conspire to establish a kind of "quantum communication channel".  This is done by Alice creating a pair of entangled particles, shipping one member of the pair off to Bob and keeping the other member of the pair for herself.  The entangled particles serve as the two ends of an ebit.  Their states, although individually ambiguous, are highly correlated with one another in the sense that measuring one end of the ebit instantaneously determines the value of a similar experiment performed at the other end of the ebit.  This "influence" however does not propagate through the space separating the ends of the ebit in the conventional sense.  Rather there is a lingering correlation between the states of the particles at either end of the ebit that becomes manifest when either particle is measured.
:[font = text; inactive; locked; preserveAspect; endGroup]
To illustrate how teleportation might work, we begin by exhibiting a 3 input/3 output quantum circuit that is capable of transferring an arbitrary quantum state from the top line of the input to the bottom line of the output.  However this transfer of state does not constitute teleportation, as the circuit is intact. We then severe the connections between two of the three lines in the middle of the circuit and replace the literal states that would have been transmitted with the results of measuring the states on those lines.  We no longer have a quantum circuit but instead we have a mutilated quantum circuit. Remarkably, despite the profound disturbance this causes to the states passing through the circuit, it is still possible to re-incarnate the original state that was on the top line of the input on the bottom line of the output.  However the original input state is destroyed in this process.  By a careful dissection of the mutilated circuit, we can see that the operations performed are analogous to the stages of teleportation.
:[font = section; inactive; locked; preserveAspect; startGroup]
Brassard's Teleportation "Circuit"
:[font = text; inactive; locked; preserveAspect]
Below we describe a simulation of the operation of a teleportation "circuit" devised by Canadian computer scientist Gilles Brassard.   This is not a circuit in the usual sense because some of the lines passing through the circuit are actually severed.  It is better to think of the "circuit" as a design for a sequence of operations that will succeed in teleporting an unknown state on the top line of the input to the bottom line of the output.  However, this state does not pass through the circuit in the conventional sense but rather the information in the unknown state is disassembled into a classical part and a quantum part, the two parts are transmitted through separate channels and re-combined by the receiver, Bob, to re-incarnate the original state.  Here is a sketch of the "circuit".  We will explain its composition, and how it works, shortly.
:[font = postscript; PostScript; formatAsPostScript; output; inactive; locked; preserveAspect; pictureLeft = 34; pictureWidth = 340; pictureHeight = 104]
%!
%%Creator: Mathematica
%%AspectRatio: .30693 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.049505 0.0990099 0.0693069 0.0990099 [
[ 0 0 0 0 ]
[ 1 .30693 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
P
0 0 m
1 0 L
1 .30693 L
0 .30693 L
closepath
clip
newpath
p
p
1 Mabswid
.07426 .14356 m
.07426 .19307 L
.12376 .19307 L
.12376 .14356 L
.07426 .14356 L
s
p
/Courier findfont 12 scalefont setfont
[(L)] .09901 .16832 0 0 Mshowa
P
.0495 .16832 m
.07426 .16832 L
s
.12376 .16832 m
.14851 .16832 L
s
newpath
.19802 .06931 .0198 0 365.73 arc
s
6 Mabswid
.19802 .16832 Mdot
1 Mabswid
.19802 .0495 m
.19802 .16832 L
s
.14851 .06931 m
.24752 .06931 L
s
.14851 .16832 m
.24752 .16832 L
s
.0495 .06931 m
.14851 .06931 L
s
P
p
1 Mabswid
newpath
.29703 .16832 .0198 0 365.73 arc
s
6 Mabswid
.29703 .26733 Mdot
1 Mabswid
.29703 .14851 m
.29703 .26733 L
s
.24752 .16832 m
.34653 .16832 L
s
.24752 .26733 m
.34653 .26733 L
s
.37129 .24257 m
.37129 .29208 L
.42079 .29208 L
.42079 .24257 L
.37129 .24257 L
s
p
/Courier findfont 12 scalefont setfont
[(R)] .39604 .26733 0 0 Mshowa
P
.34653 .26733 m
.37129 .26733 L
s
.42079 .26733 m
.44554 .26733 L
s
.34653 .16832 m
.44554 .16832 L
s
P
p
p
/Symbol findfont 10 scalefont setfont
[(|y>)] 0 .26733 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(|0>)] 0 .06931 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(|0>)] 0 .16832 -1 0 Mshowa
P
P
p
p
/Symbol findfont 10 scalefont setfont
[(r)] .45545 .08911 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(s)] .24752 .18812 0 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(?)] .45545 .16832 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(?)] .45545 .26733 -1 0 Mshowa
P
1 Mabswid
.24752 .06931 m
.54455 .06931 L
s
.0495 .26733 m
.24752 .26733 L
s
P
p
1 Mabswid
newpath
.59406 .06931 .0198 0 365.73 arc
s
6 Mabswid
.59406 .16832 Mdot
1 Mabswid
.59406 .0495 m
.59406 .16832 L
s
.54455 .06931 m
.64356 .06931 L
s
.54455 .16832 m
.64356 .16832 L
s
.56931 .24257 m
.56931 .29208 L
.61881 .29208 L
.61881 .24257 L
.56931 .24257 L
s
p
/Courier findfont 12 scalefont setfont
[(S)] .59406 .26733 0 0 Mshowa
P
.54455 .26733 m
.56931 .26733 L
s
.61881 .26733 m
.64356 .26733 L
s
newpath
.69307 .26733 .0198 0 365.73 arc
s
6 Mabswid
.69307 .06931 Mdot
1 Mabswid
.69307 .28713 m
.69307 .06931 L
s
.64356 .26733 m
.74257 .26733 L
s
.64356 .06931 m
.74257 .06931 L
s
.76733 .24257 m
.76733 .29208 L
.81683 .29208 L
.81683 .24257 L
.76733 .24257 L
s
p
/Courier findfont 12 scalefont setfont
[(S)] .79208 .26733 0 0 Mshowa
P
.74257 .26733 m
.76733 .26733 L
s
.81683 .26733 m
.84158 .26733 L
s
.76733 .04455 m
.76733 .09406 L
.81683 .09406 L
.81683 .04455 L
.76733 .04455 L
s
p
/Courier findfont 12 scalefont setfont
[(T)] .79208 .06931 0 0 Mshowa
P
.74257 .06931 m
.76733 .06931 L
s
.81683 .06931 m
.84158 .06931 L
s
newpath
.89109 .26733 .0198 0 365.73 arc
s
6 Mabswid
.89109 .06931 Mdot
1 Mabswid
.89109 .28713 m
.89109 .06931 L
s
.84158 .26733 m
.94059 .26733 L
s
.84158 .06931 m
.94059 .06931 L
s
.64356 .16832 m
.94059 .16832 L
s
P
p
p
/Symbol findfont 10 scalefont setfont
[(|f>)] .9505 .26733 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(|f>)] .9505 .16832 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(|y>)] .9505 .06931 -1 0 Mshowa
P
P
p
[ .01 .01 ] 0 setdash
1 Mabswid
.06188 .03218 m
.06188 .30446 L
.43317 .30446 L
.43317 .03218 L
.06188 .03218 L
s
[(Alice)] .24752 .0099 0 0 Mshowa
P
p
[ .01 .01 ] 0 setdash
1 Mabswid
.55693 .03218 m
.55693 .30446 L
.92822 .30446 L
.92822 .03218 L
.55693 .03218 L
s
[(Bob)] .74257 .0099 0 0 Mshowa
P
P
% End of Graphics
MathPictureEnd

:[font = text; inactive; locked; preserveAspect]
Brassard's teleportation "circuit" uses the following quantum gates:
:[font = input; preserveAspect]
L
R
S
T
XOR
:[font = text; inactive; preserveAspect]
L, R, S and T are all gates that act on single qubits. L and R perform rotations, and S and T perform phase shifts. XOR (for "exclusive-OR" sometimes called "controlled-NOT") acts on 3 qubits simultaneously.  We embed these gates in a larger circuit so that we can create versions of these quantum operations that act on selected lines in a quantum circuit (c.f.  the simulation of Feynman's quantum computer).
:[font = subsubsection; inactive; preserveAspect; startGroup]
Rotation & Phase-Shift Operators
:[font = text; inactive; preserveAspect]
Here are the mathematical specifications of the gates.  They are all 2 by 2 unitary matrices.
:[font = input; initialization; preserveAspect; endGroup]
*)
L = 1/Sqrt[2] {{ 1, -1},
               { 1,  1}};
R = 1/Sqrt[2] {{ 1,  1},
               {-1,  1}};
S = {{I, 0},
     {0, 1}};
T = {{-1, 0},
     {0, -I}};
(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
Embedding Rotation & Phase-Shift Operators in a Higher Dimensional Circuit
:[font = input; initialization; preserveAspect; endGroup]
*)
(* L that operates on the i-th of m qubits *)
LOP[i_, m_]:=
	Apply[Direct,
	      ReplacePart[Table[IdentityMatrix[2], {m}], L, i]]

(* R that operates on the i-th of m qubits *)
ROP[i_, m_]:=
	Apply[Direct,
	      ReplacePart[Table[IdentityMatrix[2], {m}], R, i]]

(* S that operates on the i-th of m qubits *)
SOP[i_, m_]:=
	Apply[Direct,
	      ReplacePart[Table[IdentityMatrix[2], {m}], S, i]]

(* T that operates on the i-th of m qubits *)
TOP[i_, m_]:=
	Apply[Direct,
	      ReplacePart[Table[IdentityMatrix[2], {m}], T, i]]
(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
XOR Gate
:[font = input; initialization; preserveAspect; endGroup]
*)
XOR = {{1,0,0,0},
       {0,1,0,0},
       {0,0,0,1},
       {0,0,1,0}};

XORGate[a_, b_, m_]:=
	CNGate[a, b, m]
(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
Teleportation Circuit
:[font = text; inactive; preserveAspect]
The teleportation circuit can be pictured as consisting of two parts.  One part represents the actions of Alice, the person wishing to teleport the unknown state, and the other part represents the actions of Bob, the person wishing to receive the teleported state.  In the diagram, the dashed boxes circumscribe the domains of responsibility of each party:
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 340; pictureHeight = 104; endGroup; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: .30693 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.049505 0.0990099 0.0693069 0.0990099 [
[ 0 0 0 0 ]
[ 1 .30693 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
P
0 0 m
1 0 L
1 .30693 L
0 .30693 L
closepath
clip
newpath
p
p
1 Mabswid
.07426 .14356 m
.07426 .19307 L
.12376 .19307 L
.12376 .14356 L
.07426 .14356 L
s
p
/Courier findfont 12 scalefont setfont
[(L)] .09901 .16832 0 0 Mshowa
P
.0495 .16832 m
.07426 .16832 L
s
.12376 .16832 m
.14851 .16832 L
s
newpath
.19802 .06931 .0198 0 365.73 arc
s
6 Mabswid
.19802 .16832 Mdot
1 Mabswid
.19802 .0495 m
.19802 .16832 L
s
.14851 .06931 m
.24752 .06931 L
s
.14851 .16832 m
.24752 .16832 L
s
.0495 .06931 m
.14851 .06931 L
s
P
p
1 Mabswid
newpath
.29703 .16832 .0198 0 365.73 arc
s
6 Mabswid
.29703 .26733 Mdot
1 Mabswid
.29703 .14851 m
.29703 .26733 L
s
.24752 .16832 m
.34653 .16832 L
s
.24752 .26733 m
.34653 .26733 L
s
.37129 .24257 m
.37129 .29208 L
.42079 .29208 L
.42079 .24257 L
.37129 .24257 L
s
p
/Courier findfont 12 scalefont setfont
[(R)] .39604 .26733 0 0 Mshowa
P
.34653 .26733 m
.37129 .26733 L
s
.42079 .26733 m
.44554 .26733 L
s
.34653 .16832 m
.44554 .16832 L
s
P
p
p
/Symbol findfont 10 scalefont setfont
[(|y>)] 0 .26733 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(|0>)] 0 .06931 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(|0>)] 0 .16832 -1 0 Mshowa
P
P
p
p
/Symbol findfont 10 scalefont setfont
[(r)] .45545 .08911 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(s)] .24752 .18812 0 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(?)] .45545 .16832 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(?)] .45545 .26733 -1 0 Mshowa
P
1 Mabswid
.24752 .06931 m
.54455 .06931 L
s
.0495 .26733 m
.24752 .26733 L
s
P
p
1 Mabswid
newpath
.59406 .06931 .0198 0 365.73 arc
s
6 Mabswid
.59406 .16832 Mdot
1 Mabswid
.59406 .0495 m
.59406 .16832 L
s
.54455 .06931 m
.64356 .06931 L
s
.54455 .16832 m
.64356 .16832 L
s
.56931 .24257 m
.56931 .29208 L
.61881 .29208 L
.61881 .24257 L
.56931 .24257 L
s
p
/Courier findfont 12 scalefont setfont
[(S)] .59406 .26733 0 0 Mshowa
P
.54455 .26733 m
.56931 .26733 L
s
.61881 .26733 m
.64356 .26733 L
s
newpath
.69307 .26733 .0198 0 365.73 arc
s
6 Mabswid
.69307 .06931 Mdot
1 Mabswid
.69307 .28713 m
.69307 .06931 L
s
.64356 .26733 m
.74257 .26733 L
s
.64356 .06931 m
.74257 .06931 L
s
.76733 .24257 m
.76733 .29208 L
.81683 .29208 L
.81683 .24257 L
.76733 .24257 L
s
p
/Courier findfont 12 scalefont setfont
[(S)] .79208 .26733 0 0 Mshowa
P
.74257 .26733 m
.76733 .26733 L
s
.81683 .26733 m
.84158 .26733 L
s
.76733 .04455 m
.76733 .09406 L
.81683 .09406 L
.81683 .04455 L
.76733 .04455 L
s
p
/Courier findfont 12 scalefont setfont
[(T)] .79208 .06931 0 0 Mshowa
P
.74257 .06931 m
.76733 .06931 L
s
.81683 .06931 m
.84158 .06931 L
s
newpath
.89109 .26733 .0198 0 365.73 arc
s
6 Mabswid
.89109 .06931 Mdot
1 Mabswid
.89109 .28713 m
.89109 .06931 L
s
.84158 .26733 m
.94059 .26733 L
s
.84158 .06931 m
.94059 .06931 L
s
.64356 .16832 m
.94059 .16832 L
s
P
p
p
/Symbol findfont 10 scalefont setfont
[(|f>)] .9505 .26733 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(|f>)] .9505 .16832 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(|y>)] .9505 .06931 -1 0 Mshowa
P
P
p
[ .01 .01 ] 0 setdash
1 Mabswid
.06188 .03218 m
.06188 .30446 L
.43317 .30446 L
.43317 .03218 L
.06188 .03218 L
s
[(Alice)] .24752 .0099 0 0 Mshowa
P
p
[ .01 .01 ] 0 setdash
1 Mabswid
.55693 .03218 m
.55693 .30446 L
.92822 .30446 L
.92822 .03218 L
.55693 .03218 L
s
[(Bob)] .74257 .0099 0 0 Mshowa
P
P
% End of Graphics
MathPictureEnd

:[font = section; inactive; preserveAspect; startGroup]
Teleporting an Unknown State from Alice to Bob
:[font = subsection; inactive; preserveAspect; startGroup]
Step 1: Preparation (Alice's job)
:[font = text; inactive; preserveAspect]
For Alice to teleport an arbitrary, unknown, quantum state to Bob, she begins by creating a pair of particles whose quantum states are highly correlated with one another.  Alice keeps one of these particles and sends the other to Bob (via the bottom line of the teleportation "circuit").  Although the two particles become physically remote from one another, the correlation between their states persists so long as neither particle is measured nor interacts with its environment in any way.  Such correlated particles are referred to as "ebits" in the jargon of quantum computing.

To create the ebits, Alice pushes two standard states (two particles each in state |0>) through the following circuit.
:[font = input; preserveAspect; startGroup]
AliceCreatesEbit[];
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 183; pictureHeight = 113; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: .625 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.126437 0.410509 0.0969828 0.410509 [
[ 0 0 0 0 ]
[ 1 .625 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
P
0 0 m
1 0 L
1 .625 L
0 .625 L
closepath
clip
newpath
p
p
1 Mabswid
.22906 .40486 m
.22906 .61012 L
.43432 .61012 L
.43432 .40486 L
.22906 .40486 L
s
p
/Courier findfont 12 scalefont setfont
[(L)] .33169 .50749 0 0 Mshowa
P
.12644 .50749 m
.22906 .50749 L
s
.43432 .50749 m
.53695 .50749 L
s
newpath
.7422 .09698 .0821 0 365.73 arc
s
6 Mabswid
.7422 .50749 Mdot
1 Mabswid
.7422 .01488 m
.7422 .50749 L
s
.53695 .09698 m
.94745 .09698 L
s
.53695 .50749 m
.94745 .50749 L
s
.12644 .09698 m
.53695 .09698 L
s
P
p
p
/Symbol findfont 12 scalefont setfont
[(| 0 >)] .02381 .09698 -1 0 Mshowa
P
p
/Symbol findfont 12 scalefont setfont
[(| 0 >)] .02381 .50749 -1 0 Mshowa
P
p
/Symbol findfont 12 scalefont setfont
[(s)] .97619 .50749 -1 0 Mshowa
P
p
/Symbol findfont 12 scalefont setfont
[(r)] .97619 .09698 -1 0 Mshowa
P
P
P
% End of Graphics
MathPictureEnd

:[font = text; inactive; preserveAspect]

The outputs are labelled by sigma and rho rather than individual ket vectors because the states on each output line are not pure states.  Instead, the output states are entangled with one another.  To see this, look at the action of this circuit algebraically:
:[font = text; inactive; preserveAspect]
The circuit consists of an L gate and an XOR gate. There are two lines in the circuit. We can number the top line as "line 1" and the bottom line as "line 2". Thus the circuit can be described as the dot product of the matrices representing the action of each gate. LOP[i,m] is an L gate that acts on the i-th of m qubits. XORGate[i,j,m] is an XOR gate that acts on the i-th and j-th of m qubits.  So the overall operation of the circuit is described by XORGate[1,2,2] . LOP[1,2].

The circuit has two inputs, represented by two kets (which will actually both be set to the standard state |0>).  So the overall action of the circuit on an arbitrary pair of states is defined by the command Step1:
:[font = input; initialization; preserveAspect]
*)
Step1[ket1_, ket2_]:=
	(XORGate[1,2,2] . 
	 LOP[1,2] . 
	 KetToColumnVector[Direct[ket1, ket2]]) // ColumnVectorToKet
(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = text; inactive; preserveAspect]
To see what this circuit does to the state input state |00>, try the following.
:[font = input; preserveAspect; startGroup]
Step1[ket[0], ket[0]]
	
:[font = output; output; inactive; preserveAspect; endGroup]
ket[0, 0]/2^(1/2) + ket[1, 1]/2^(1/2)
;[o]
ket[0, 0]   ket[1, 1]
--------- + ---------
 Sqrt[2]     Sqrt[2]
:[font = text; inactive; preserveAspect; endGroup; endGroup]
Notice that the resulting state is entangled: if you measured one of the outputs and obtained the answer "0", then a subsequent measurement on the other output would also yield the answer "0". Likewise, if you measured one of the outputs and obtained the answer "1", a subsequent measurement on the other output would also yield a "1".  Hence, although each output is in a superposition of 0 and 1, the joint state of the outputs are strongly correlated, or "entangled", with one another.   By retaining one of these output states and sending the other to Bob, Alice establishes a quantum communication channel between herself and Bob via the enduring correlation between the ebits labelled sigma and rho.
:[font = subsection; inactive; preserveAspect; startGroup]
Step 2: Entanglement (also Alice's job)
:[font = text; inactive; preserveAspect]
Next, suppose Alice wants to teleport a particular quantum state to Bob. Alice need not know what this state is in order to teleport it successfully, so without loss of generality we can say that the state is "unknown".  To teleport the state, Alice entangles it with one of the ebits she created in Step 1. Again the entangling is done by pushing certain states through a particular quantum circuit.  In this case the circuit  is shown below:
:[font = input; preserveAspect; startGroup]
AliceEntanglesEbitWithUnknownState[]
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 162]
%!
%%Creator: Mathematica
%%AspectRatio: .57647 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0798319 0.22409 0.0585434 0.22409 [
[ 0 0 0 0 ]
[ 1 .57647 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
P
0 0 m
1 0 L
1 .57647 L
0 .57647 L
closepath
clip
newpath
p
p
1 Mabswid
.13585 .22661 m
.13585 .33866 L
.2479 .33866 L
.2479 .22661 L
.13585 .22661 L
s
p
/Courier findfont 12 scalefont setfont
[(L)] .19188 .28263 0 0 Mshowa
P
.07983 .28263 m
.13585 .28263 L
s
.2479 .28263 m
.30392 .28263 L
s
newpath
.41597 .05854 .04482 0 365.73 arc
s
6 Mabswid
.41597 .28263 Mdot
1 Mabswid
.41597 .01373 m
.41597 .28263 L
s
.30392 .05854 m
.52801 .05854 L
s
.30392 .28263 m
.52801 .28263 L
s
.07983 .05854 m
.30392 .05854 L
s
P
p
1 Mabswid
newpath
.64006 .28263 .04482 0 365.73 arc
s
6 Mabswid
.64006 .50672 Mdot
1 Mabswid
.64006 .23782 m
.64006 .50672 L
s
.52801 .28263 m
.7521 .28263 L
s
.52801 .50672 m
.7521 .50672 L
s
.80812 .4507 m
.80812 .56275 L
.92017 .56275 L
.92017 .4507 L
.80812 .4507 L
s
p
/Courier findfont 12 scalefont setfont
[(R)] .86415 .50672 0 0 Mshowa
P
.7521 .50672 m
.80812 .50672 L
s
.92017 .50672 m
.97619 .50672 L
s
.7521 .28263 m
.97619 .28263 L
s
P
p
p
/Symbol findfont 12 scalefont setfont
[(| y >)] .02381 .50672 -1 0 Mshowa
P
p
/Symbol findfont 12 scalefont setfont
[(| 0 >)] .02381 .05854 -1 0 Mshowa
P
p
/Symbol findfont 12 scalefont setfont
[(| 0 >)] .02381 .28263 -1 0 Mshowa
P
P
P
% End of Graphics
MathPictureEnd

:[font = output; output; inactive; preserveAspect; endGroup]
Graphics["<<>>"]
;[o]
-Graphics-
:[font = text; inactive; preserveAspect]
The correct quantum mechanical description of this circuit now involves three inputs and three outputs. Algebraically the state transformation is given by:
:[font = input; initialization; preserveAspect]
*)
Step2[ket1_, ket2_, ket3_]:=
	(ROP[1,3] .
	 XORGate[1,2,3] .
	 XORGate[2,3,3] .
	 LOP[2,3] . KetToColumnVector[Direct[ket1, ket2, ket3]]) // ColumnVectorToKet
(*
:[font = text; inactive; preserveAspect]
Let's invent a random arbitrary state, a |0> + b |1>, and see what this circuit does to this state:
:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = input; preserveAspect; startGroup]
Step2[a ket[0] + b ket[1], ket[0], ket[0] ]
:[font = output; output; inactive; preserveAspect; endGroup]
(a*ket[0, 0, 0])/2 + (b*ket[0, 0, 1])/2 + (b*ket[0, 1, 0])/2 + (a*ket[0, 1, 1])/2 - 
 
  (a*ket[1, 0, 0])/2 + (b*ket[1, 0, 1])/2 + (b*ket[1, 1, 0])/2 - (a*ket[1, 1, 1])/2
;[o]
a ket[0, 0, 0]   b ket[0, 0, 1]   b ket[0, 1, 0]   a ket[0, 1, 1]
-------------- + -------------- + -------------- + -------------- - 
      2                2                2                2
 
  a ket[1, 0, 0]   b ket[1, 0, 1]   b ket[1, 1, 0]   a ket[1, 1, 1]
  -------------- + -------------- + -------------- - --------------
        2                2                2                2
:[font = text; inactive; preserveAspect]
We can also examine the action of Alice's circuit on a specific state such as:
           .5 |0> + Sqrt[1-.5^2] |1>  
i.e. if you were to measure this state in the 0/1 basis, you would have a 25% chance of obtaining a 0 and a 75% chance of obtaining a 1.
:[font = input; preserveAspect; startGroup]
unknownState = .5 ket[0] + Sqrt[1-.5^2] ket[1]
:[font = output; output; inactive; preserveAspect; endGroup; endGroup]
0.5*ket[0] + 0.866025403784439*ket[1]
;[o]
0.5 ket[0] + 0.866025 ket[1]
:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = text; inactive; preserveAspect]
Here is the action of Alice on this state:
:[font = input; preserveAspect; startGroup]
state2 = Step2[.5 ket[0] + Sqrt[1-.5^2] ket[1], ket[0], ket[0] ]
:[font = output; output; inactive; preserveAspect; endGroup]
0.25*ket[0, 0, 0] + 0.4330127018922193*ket[0, 0, 1] + 
 
  0.4330127018922193*ket[0, 1, 0] + 0.25*ket[0, 1, 1] - 0.25*ket[1, 0, 0] + 
 
  0.4330127018922193*ket[1, 0, 1] + 0.4330127018922193*ket[1, 1, 0] - 
 
  0.25*ket[1, 1, 1]
;[o]
0.25 ket[0, 0, 0] + 0.433013 ket[0, 0, 1] + 0.433013 ket[0, 1, 0] + 
 
  0.25 ket[0, 1, 1] - 0.25 ket[1, 0, 0] + 0.433013 ket[1, 0, 1] + 
 
  0.433013 ket[1, 1, 0] - 0.25 ket[1, 1, 1]
:[font = text; inactive; preserveAspect; endGroup; endGroup]
This represents the joint state of the 3 qubits after Alice has pushed the 3 inputs through her circuit.
:[font = subsection; inactive; preserveAspect; startGroup]
Step 3: Measurement (Alice's last job)
:[font = text; inactive; preserveAspect]
Next Alice measures the bits on lines 1 and 2 (the top and middle line). To simulate this, we use the command ReadPartOfMemoryRegister that was introduced in the simulator for Feynman's quantum computer.  Here is a reminder of how to use this command:
:[font = input; preserveAspect; startGroup]
?ReadPartOfMemoryRegister
:[font = print; inactive; preserveAspect; endGroup]
ReadPartOfMemoryRegister[superposition, bitsToRead] reads the state of selected bits
   in the memory register. As the i-th and j-th bit measurement operators commute (for
   any i and j), it does not matter in what order you measure the bits.
:[font = text; inactive; preserveAspect]
You may recall that the output from ReadPartOfMemoryRegister consists of a two element list: the first element is a record of the answers obtained for each bit measured and the second element is the state the memory register is left in after all the measurements have been made.
:[font = input; initialization; preserveAspect]
*)
Step3[state_]:=
	ReadPartOfMemoryRegister[state, {1,2}]
(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = input; preserveAspect; startGroup]
answer3 = ReadPartOfMemoryRegister[state2, {1,2}]
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup; endGroup]
{{0, 0}, 0.5000000000000001*ket[0, 0, 0] + 0.866025403784439*ket[0, 0, 1]}
;[o]
{{0, 0}, 0.5 ket[0, 0, 0] + 0.866025 ket[0, 0, 1]}
:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = text; inactive; preserveAspect]
This output labelled answer3 means Alice read a ...
:[font = input; preserveAspect; startGroup]
line1Bit = answer3[[1,1]]
:[font = output; output; inactive; preserveAspect; endGroup]
0
;[o]
0
:[font = text; inactive; preserveAspect]
... for line 1 (the top line) and a ... 
:[font = input; preserveAspect; startGroup]
line2Bit = answer3[[1,2]]
:[font = output; output; inactive; preserveAspect; endGroup]
0
;[o]
0
:[font = text; inactive; preserveAspect]
... for line 2 (the middle line) at the center of the circuit.  The joint state of the three qubits at the mid-point of the circuit after both of these measurements have been made is ...
:[font = input; preserveAspect; startGroup]
state3 = answer3[[2]]
:[font = output; output; inactive; preserveAspect; endGroup]
0.5000000000000001*ket[0, 0, 0] + 0.866025403784439*ket[0, 0, 1]
;[o]
0.5 ket[0, 0, 0] + 0.866025 ket[0, 0, 1]
:[font = text; inactive; preserveAspect; endGroup]
Notice that Alice did not attempt to read the state of the particle on the third line. In fact, this corresponds to the ebit already in Bob's possession. 
:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me! (an aside...)
:[font = text; inactive; preserveAspect; plain; italic]
Note that, if you measure identically prepared quantum circuits, which are all initialized with identical inputs,  you can obtain different answers for the measurements in each case. To see this try re-running the last command a few times.
:[font = input; preserveAspect; startGroup]
Table[ReadPartOfMemoryRegister[state2,{1,2}], {5}] // ColumnForm
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
{{0, 1}, 0.866025403784439*ket[0, 1, 0] + 0.5000000000000001*ket[0, 1, 1]}
{{1, 0}, -0.5000000000000001*ket[1, 0, 0] + 0.866025403784439*ket[1, 0, 1]}
{{1, 1}, 0.866025403784439*ket[1, 1, 0] - 0.5000000000000001*ket[1, 1, 1]}
{{1, 1}, 0.866025403784439*ket[1, 1, 0] - 0.5000000000000001*ket[1, 1, 1]}
{{0, 1}, 0.866025403784439*ket[0, 1, 0] + 0.5000000000000001*ket[0, 1, 1]}
;[o]
{{0, 1}, 0.866025 ket[0, 1, 0] + 0.5 ket[0, 1, 1]}
{{1, 0}, -0.5 ket[1, 0, 0] + 0.866025 ket[1, 0, 1]}
{{1, 1}, 0.866025 ket[1, 1, 0] - 0.5 ket[1, 1, 1]}
{{1, 1}, 0.866025 ket[1, 1, 0] - 0.5 ket[1, 1, 1]}
{{0, 1}, 0.866025 ket[0, 1, 0] + 0.5 ket[0, 1, 1]}
:[font = text; inactive; preserveAspect; plain; italic]
Such repeated measurements are not necessary for quantum teleportation. This exercise merely illustrates that the outcomes of measurements on quantum systems in superposed states is not deterministic.
:[font = text; inactive; preserveAspect]
Back to business ... Alice's final task is simply to send the results of her measurements to Bob via a classical communication channel such as sound waves, radio, telephone, or written letter. In the present example, Alice would tell Bob she obtained the value stored in the variable "line1Bit" for line 1 and the value stored in the variable "line2Bit" for line 2 of the circuit at the mid-point.  After these measurements, the state of the circuit at the mid-point is given by the value of the variable state3. In the present example, Alice obtained the results:
:[font = input; preserveAspect; startGroup]
line1Bit
:[font = output; output; inactive; preserveAspect; endGroup]
0
;[o]
0
:[font = input; preserveAspect; startGroup]
line2Bit
:[font = output; output; inactive; preserveAspect; endGroup]
0
;[o]
0
:[font = input; preserveAspect; startGroup]
state3
:[font = output; output; inactive; preserveAspect; endGroup; endGroup; endGroup]
0.5000000000000001*ket[0, 0, 0] + 0.866025403784439*ket[0, 0, 1]
;[o]
0.5 ket[0, 0, 0] + 0.866025 ket[0, 0, 1]
:[font = subsection; inactive; preserveAspect; startGroup]
Step 4 (Bob's job)
:[font = text; inactive; preserveAspect]
Bob receive's Alice's 2-bit classical message and immediately converts those bits to corresponding kets for input into the quantum circuit shown below. That is if Alice tells Bob she read a 1 on line 1, Bob creates the state |1> for input on line 1 of the following circuit:
:[font = input; preserveAspect; startGroup]
BobCircuit[];
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 178; pictureHeight = 110; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: .625 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
-1.16667 0.238095 0.0744048 0.238095 [
[ 0 0 0 0 ]
[ 1 .625 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
P
0 0 m
1 0 L
1 .625 L
0 .625 L
closepath
clip
newpath
p
1 Mabswid
newpath
.14286 .0744 .04762 0 365.73 arc
s
6 Mabswid
.14286 .3125 Mdot
1 Mabswid
.14286 .02679 m
.14286 .3125 L
s
.02381 .0744 m
.2619 .0744 L
s
.02381 .3125 m
.2619 .3125 L
s
.08333 .49107 m
.08333 .61012 L
.20238 .61012 L
.20238 .49107 L
.08333 .49107 L
s
p
/Courier findfont 12 scalefont setfont
[(S)] .14286 .5506 0 0 Mshowa
P
.02381 .5506 m
.08333 .5506 L
s
.20238 .5506 m
.2619 .5506 L
s
newpath
.38095 .5506 .04762 0 365.73 arc
s
6 Mabswid
.38095 .0744 Mdot
1 Mabswid
.38095 .59821 m
.38095 .0744 L
s
.2619 .5506 m
.5 .5506 L
s
.2619 .0744 m
.5 .0744 L
s
.55952 .49107 m
.55952 .61012 L
.67857 .61012 L
.67857 .49107 L
.55952 .49107 L
s
p
/Courier findfont 12 scalefont setfont
[(S)] .61905 .5506 0 0 Mshowa
P
.5 .5506 m
.55952 .5506 L
s
.67857 .5506 m
.7381 .5506 L
s
.55952 .01488 m
.55952 .13393 L
.67857 .13393 L
.67857 .01488 L
.55952 .01488 L
s
p
/Courier findfont 12 scalefont setfont
[(T)] .61905 .0744 0 0 Mshowa
P
.5 .0744 m
.55952 .0744 L
s
.67857 .0744 m
.7381 .0744 L
s
newpath
.85714 .5506 .04762 0 365.73 arc
s
6 Mabswid
.85714 .0744 Mdot
1 Mabswid
.85714 .59821 m
.85714 .0744 L
s
.7381 .5506 m
.97619 .5506 L
s
.7381 .0744 m
.97619 .0744 L
s
.2619 .3125 m
.97619 .3125 L
s
P
% End of Graphics
MathPictureEnd

:[font = text; inactive; preserveAspect]
In the present example
:[font = input; initialization; preserveAspect]
*)
Step4[b1_, b2_, state_]:=
	(XORGate[3,1,3] .
	 TOP[3,3] .
	 SOP[1,3] .
	 XORGate[3,1,3] .
	 XORGate[2,3,3] .
	 SOP[1,3] . 
	 KetToColumnVector[Direct[ket[b1], ket[b2], StateOnLine3[state]]]
	) // Chop // ColumnVectorToKet

StateOnLine3[a_. ket[b1_,b2_,b30_] + b_. ket[b1_,b2_,b31_]]:=
	a ket[b30] + b ket[b31]	

(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = input; preserveAspect; startGroup]
outputState = Step4[line1Bit, line2Bit, state3]
:[font = output; output; inactive; preserveAspect; endGroup]
0.5000000000000001*ket[0, 0, 0] + 0.866025403784439*ket[0, 0, 1]
;[o]
0.5 ket[0, 0, 0] + 0.866025 ket[0, 0, 1]
:[font = input; preserveAspect; startGroup]
StateOnLine3[outputState]
:[font = output; output; inactive; preserveAspect; endGroup]
0.5000000000000001*ket[0] + 0.866025403784439*ket[1]
;[o]
0.5 ket[0] + 0.866025 ket[1]
:[font = text; inactive; preserveAspect]
Does this match the original state? As a check ask for the value of unknownState.
:[font = input; preserveAspect; startGroup]
unknownState
:[font = output; output; inactive; preserveAspect; endGroup; endGroup; endGroup; endGroup]
0.5*ket[0] + 0.866025403784439*ket[1]
;[o]
0.5 ket[0] + 0.866025 ket[1]
:[font = section; inactive; preserveAspect; startGroup]
The Teleport Command
:[font = text; inactive; preserveAspect]
We now bundle all these steps together into a self-documenting program called Teleport.
:[font = input; preserveAspect; startGroup]
?Teleport
:[font = print; inactive; preserveAspect]
Teleport[state] generates a self-documenting simulation of the process of teleporting
   the given state from Alice to Bob.
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 340; pictureHeight = 104; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: .30693 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.049505 0.0990099 0.0693069 0.0990099 [
[ 0 0 0 0 ]
[ 1 .30693 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
P
0 0 m
1 0 L
1 .30693 L
0 .30693 L
closepath
clip
newpath
p
p
1 Mabswid
.07426 .14356 m
.07426 .19307 L
.12376 .19307 L
.12376 .14356 L
.07426 .14356 L
s
p
/Courier findfont 12 scalefont setfont
[(L)] .09901 .16832 0 0 Mshowa
P
.0495 .16832 m
.07426 .16832 L
s
.12376 .16832 m
.14851 .16832 L
s
newpath
.19802 .06931 .0198 0 365.73 arc
s
6 Mabswid
.19802 .16832 Mdot
1 Mabswid
.19802 .0495 m
.19802 .16832 L
s
.14851 .06931 m
.24752 .06931 L
s
.14851 .16832 m
.24752 .16832 L
s
.0495 .06931 m
.14851 .06931 L
s
P
p
1 Mabswid
newpath
.29703 .16832 .0198 0 365.73 arc
s
6 Mabswid
.29703 .26733 Mdot
1 Mabswid
.29703 .14851 m
.29703 .26733 L
s
.24752 .16832 m
.34653 .16832 L
s
.24752 .26733 m
.34653 .26733 L
s
.37129 .24257 m
.37129 .29208 L
.42079 .29208 L
.42079 .24257 L
.37129 .24257 L
s
p
/Courier findfont 12 scalefont setfont
[(R)] .39604 .26733 0 0 Mshowa
P
.34653 .26733 m
.37129 .26733 L
s
.42079 .26733 m
.44554 .26733 L
s
.34653 .16832 m
.44554 .16832 L
s
P
p
p
/Symbol findfont 10 scalefont setfont
[(|y>)] 0 .26733 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(|0>)] 0 .06931 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(|0>)] 0 .16832 -1 0 Mshowa
P
P
p
p
/Symbol findfont 10 scalefont setfont
[(r)] .45545 .08911 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(s)] .24752 .18812 0 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(?)] .45545 .16832 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(?)] .45545 .26733 -1 0 Mshowa
P
1 Mabswid
.24752 .06931 m
.54455 .06931 L
s
.0495 .26733 m
.24752 .26733 L
s
P
p
1 Mabswid
newpath
.59406 .06931 .0198 0 365.73 arc
s
6 Mabswid
.59406 .16832 Mdot
1 Mabswid
.59406 .0495 m
.59406 .16832 L
s
.54455 .06931 m
.64356 .06931 L
s
.54455 .16832 m
.64356 .16832 L
s
.56931 .24257 m
.56931 .29208 L
.61881 .29208 L
.61881 .24257 L
.56931 .24257 L
s
p
/Courier findfont 12 scalefont setfont
[(S)] .59406 .26733 0 0 Mshowa
P
.54455 .26733 m
.56931 .26733 L
s
.61881 .26733 m
.64356 .26733 L
s
newpath
.69307 .26733 .0198 0 365.73 arc
s
6 Mabswid
.69307 .06931 Mdot
1 Mabswid
.69307 .28713 m
.69307 .06931 L
s
.64356 .26733 m
.74257 .26733 L
s
.64356 .06931 m
.74257 .06931 L
s
.76733 .24257 m
.76733 .29208 L
.81683 .29208 L
.81683 .24257 L
.76733 .24257 L
s
p
/Courier findfont 12 scalefont setfont
[(S)] .79208 .26733 0 0 Mshowa
P
.74257 .26733 m
.76733 .26733 L
s
.81683 .26733 m
.84158 .26733 L
s
.76733 .04455 m
.76733 .09406 L
.81683 .09406 L
.81683 .04455 L
.76733 .04455 L
s
p
/Courier findfont 12 scalefont setfont
[(T)] .79208 .06931 0 0 Mshowa
P
.74257 .06931 m
.76733 .06931 L
s
.81683 .06931 m
.84158 .06931 L
s
newpath
.89109 .26733 .0198 0 365.73 arc
s
6 Mabswid
.89109 .06931 Mdot
1 Mabswid
.89109 .28713 m
.89109 .06931 L
s
.84158 .26733 m
.94059 .26733 L
s
.84158 .06931 m
.94059 .06931 L
s
.64356 .16832 m
.94059 .16832 L
s
P
p
p
/Symbol findfont 10 scalefont setfont
[(|f>)] .9505 .26733 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(|f>)] .9505 .16832 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(|y>)] .9505 .06931 -1 0 Mshowa
P
P
p
[ .01 .01 ] 0 setdash
1 Mabswid
.06188 .03218 m
.06188 .30446 L
.43317 .30446 L
.43317 .03218 L
.06188 .03218 L
s
[(Alice)] .24752 .0099 0 0 Mshowa
P
p
[ .01 .01 ] 0 setdash
1 Mabswid
.55693 .03218 m
.55693 .30446 L
.92822 .30446 L
.92822 .03218 L
.55693 .03218 L
s
[(Bob)] .74257 .0099 0 0 Mshowa
P
P
% End of Graphics
MathPictureEnd

:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
Code for teleportation simnulation in here ...
:[font = input; initialization; preserveAspect]
*)
CreateUnknownState[]:=
	Module[{a,b},
		a = N[Random[Real,{-1,1}] Exp[I Random[Real,{0, N[2 Pi]}]]];
		b = Sqrt[1-Abs[a]^2];
		a ket[0] + b ket[1]
	]
(*
:[font = input; initialization; preserveAspect]
*)

Options[Teleport] = {TraceProgress->True};

Teleport[unknownState_, opts___]:=
	Module[{ebit, state2, bit1, bit2, state3, state4},
		traceQ = TraceProgress /. {opts} /. Options[Teleport];
		If[traceQ,
		   (Print["The state to be teleported is: ", unknownState];
		    Print["This state is unknown to both Alice and Bob.\n\n"])];
		ebit   = Step1[ket[0], ket[0]];
		If[traceQ,
		   (Print["Step 1:"];
		    Print["Alice creates a pair of ebits in the joint state: 1/Sqrt[2] (|00>+|11>)"];
		    Print["Alice keeps one ebit and sends the other to Bob.\n\n"])];
		state2 = Step2[unknownState, ket[0], ket[0]];
		If[traceQ,
		   (Print["Step 2:"];
		    Print["Alice entangles the unknown state with the ebit she retained in Step 1."]
		    Print["To do this, Alice pushes the states:"];
		    Print["   "<>ToString[unknownState]];
		    Print["   |0>"];
		    Print["   |0>"];
		    Print["through her circuit."];
		    Print["The resulting state (at the mid-point of the circuit) is:"];
		    Print[state2];
		    Print["\n"])];
		{{bit1,bit2}, state3} = Step3[state2];
		If[traceQ,
		   (Print["Step 3:"];
		    Print["Alice measures the state on lines 1 and 2 to obtain the bits: ", {bit1, bit2}];
		    Print["   and conveys these results to Bob via a classical 2-bit message.\n\n"];
		   )];
		state4 = Step4[bit1, bit2, state3];
		If[traceQ,
		   (Print["Step 4:"];
		    Print["Bob receives Alices classical 2-bit message and creates the"];
		    Print["   inputs |"<>ToString[bit1]<>"> and |"<>ToString[bit2]<>"> for input to line 1 and line 2 of his circuit."];
		    Print["Because of the ebit Alice created, and the measurement she made,"];
		    Print["   the state on line 3 entering Bob's circuit is:"];
		    Print[StateOnLine3[state3]];
		    Print["\n\n"]
		   )
		  ];
		  If[traceQ,
		     (Print["Step 5:"];
		      Print["Bob pushes the three states:"];
		      Print["   |"<>ToString[bit1]<>">,"];
		      Print["   |"<>ToString[bit2]<>"> and "];
		      Print["   "<>ToString[StateOnLine3[state3]]];
		      Print["through his circuit to obtain the output:"];
		      Print["   "<>ToString[state4]];
		      Print["Thus the state on line 3 of the output is:"];
		      Print["   "<>ToString[StateOnLine3[state4]]];
		      Print["Compare this with the \"unknown\" state on line 1 of Alice's input:"];
		      Print["   "<>ToString[unknownState]];
		      Print["They are the same!"];
		      Print["Thus the unknown state on line 1 of the input has been teleported to line 3 of the output."]
		     )
		    ];
		StateOnLine3[state4]
	]

Teleport::usage =
	"Teleport[state] generates a self-documenting simulation of the \
	process of teleporting the given state from Alice to Bob.";
(*
:[font = input; preserveAspect; startGroup]
?Teleport
:[font = print; inactive; preserveAspect; endGroup; endGroup]
Global`Teleport

Teleport[state1_, state2_, state3_] := Teleport[Direct[state1, state2, state3]]
 
Teleport[directProduct_List] := 
  ColumnVectorToKet[TeleportationCircuit[] . directProduct]
 
Teleport[state_] := 
  ColumnVectorToKet[TeleportationCircuit[] . KetToColumnVector[state]]
 
Teleport[unknownState_, opts___] := 
  Module[{ebit, state2, bit1, bit2, state3, state4}, 
   traceQ = TraceProgress /. {opts} /. Options[Teleport]; 
    If[traceQ, Print["The state to be teleported is: ", unknownState]; 
      Print["This state is unknown to both Alice and Bob.\n\n"]]; 
    ebit = Step1[ket[0], ket[0]]; If[traceQ, 
     Print["Step 1:"]; Print["Alice creates a pair of ebits in the joint state:\
        1/Sqrt[2] (|00>+|11>)"]; Print["Alice keeps one ebit and sends the other to\
        Bob.\n\n"]]; state2 = Step2[unknownState, ket[0], ket[0]]; 
    If[traceQ, Print["Step 2:"]; Print["Alice entangles the unknown state with\
         the ebit she retained in Step 1."]*
       Print["To do this, Alice pushes the states:"]; 
      Print[StringJoin["   ", ToString[unknownState]]]; Print["   |0>"]; 
      Print["   |0>"]; Print["through her circuit."]; 
      Print["The resulting state (at the mid-point of the circuit) is:"]; 
      Print[state2]; Print["\n"]]; {{bit1, bit2}, state3} = Step3[state2]; 
    If[traceQ, Print["Step 3:"]; Print["Alice measures the state on lines 1 and 2\
        to obtain the bits: ", {bit1, bit2}]; 
      Print["   and conveys these results to Bob via a classical 2-bit\
        message.\n\n"]; Null]; state4 = Step4[bit1, bit2, state3]; 
    If[traceQ, Print["Step 4:"]; Print["Bob receives Alices classical 2-bit\
        message and creates the"]; 
      Print[StringJoin["   inputs |", ToString[bit1], "> and |", ToString[bit2]\
         , "> for input to line 1 and line 2 of his circuit."]]; 
      Print["Because of the ebit Alice created, and the measurement she made,"]; 
      Print["   the state on line 3 entering Bob's circuit is:"]; 
      Print[StateOnLine3[state3]]; Print["\n\n"]]; 
    If[traceQ, Print["Step 5:"]; Print["Bob pushes the three states:"]; 
      Print[StringJoin["   |", ToString[bit1], ">,"]]; 
      Print[StringJoin["   |", ToString[bit2], "> and "]]; 
      Print[StringJoin["   ", ToString[StateOnLine3[state3]]]]; 
      Print["through his circuit to obtain the output:"]; 
      Print[StringJoin["   ", ToString[state4]]]; 
      Print["Thus the state on line 3 of the output is:"]; 
      Print[StringJoin["   ", ToString[StateOnLine3[state4]]]]; 
      Print["Compare this with the \"unknown\" state on line 1 of Alice's input:"]; 
      Print[StringJoin["   ", ToString[unknownState]]]; 
      Print["They are the same!"]; 
      Print["Thus the unknown state on line 1 of the input has been teleported to\
        line 3 of the output."]]; StateOnLine3[state4]]
 
Options[Teleport] = {TraceProgress -> True}
:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = text; inactive; preserveAspect]
You can make Mathematica generate a complete simulation of the teleportation process. To begin, you must generate an "unknown" state. To generate the unknown state, use CreateUnknownState[].
;[s]
3:0,0;13,1;24,0;191,-1;
2:2,13,9,Times,0,12,0,0,0;1,13,9,Times,2,12,0,0,0;
:[font = input; preserveAspect; startGroup]
unknownState = CreateUnknownState[]
:[font = output; output; inactive; preserveAspect; endGroup]
(0.185431468211207 - 0.1128255014834253*I)*ket[0] + 0.976158581795012*ket[1]
;[o]
(0.185431 - 0.112826 I) ket[0] + 0.976159 ket[1]
:[font = text; inactive; preserveAspect; endGroup]
The simply call Teleport[unknownState] and watch the sequence of steps as the state is teleported through the circuit.
:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = input; preserveAspect; startGroup]
Teleport[unknownState]
:[font = print; inactive; preserveAspect]
The state to be teleported is: (0.185431 - 0.112826 I) ket[0] + 0.976159 ket[1]
This state is unknown to both Alice and Bob.


Step 1:
Alice creates a pair of ebits in the joint state: 1/Sqrt[2] (|00>+|11>)
Alice keeps one ebit and sends the other to Bob.


Step 2:
Alice entangles the unknown state with the ebit she retained in Step 1.
To do this, Alice pushes the states:
   (0.185431 - 0.112826 I) ket[0] + 0.976159 ket[1]
   |0>
   |0>
through her circuit.
The resulting state (at the mid-point of the circuit) is:
(0.0927157 - 0.0564128 I) ket[0, 0, 0] + 0.488079 ket[0, 0, 1] + 
 
  0.488079 ket[0, 1, 0] + (0.0927157 - 0.0564128 I) ket[0, 1, 1] + 
 
  (-0.0927157 + 0.0564128 I) ket[1, 0, 0] + 0.488079 ket[1, 0, 1] + 
 
  0.488079 ket[1, 1, 0] + (-0.0927157 + 0.0564128 I) ket[1, 1, 1]


Step 3:
Alice measures the state on lines 1 and 2 to obtain the bits: {1, 0}
   and conveys these results to Bob via a classical 2-bit message.


Step 4:
Bob receives Alices classical 2-bit message and creates the
   inputs |1> and |0> for input to line 1 and line 2 of his circuit.
Because of the ebit Alice created, and the measurement she made,
   the state on line 3 entering Bob's circuit is:
(-0.185431 + 0.112826 I) ket[0] + 0.976159 ket[1]



Step 5:
Bob pushes the three states:
   |1>,
   |0> and 
   (-0.185431 + 0.112826 I) ket[0] + 0.976159 ket[1]
through his circuit to obtain the output:
   (0.185431 - 0.112826 I) ket[1, 0, 0] + 0.976159 ket[1, 0, 1]
Thus the state on line 3 of the output is:
   (0.185431 - 0.112826 I) ket[0] + 0.976159 ket[1]
Compare this with the "unknown" state on line 1 of Alice's input:
   (0.185431 - 0.112826 I) ket[0] + 0.976159 ket[1]
They are the same!
Thus the unknown state on line 1 of the input has been teleported to line 3 of the\
 
  output.
:[font = output; output; inactive; preserveAspect; endGroup; endGroup; endGroup]
(0.185431468211207 - 0.1128255014834253*I)*ket[0] + 0.976158581795012*ket[1]
;[o]
(0.185431 - 0.112826 I) ket[0] + 0.976159 ket[1]
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Circuit diagrams in here ...
:[font = input; initialization; preserveAspect]
*)
Circuit1[]:=
	Graphics[Join[{AbsoluteThickness[1]},
	              DrawOP["L", {0.5,1}],
	              DrawXOR[{1.5,{0,1}}],
	              {Line[{{0,0},{1,0}}]}
	             ]
	        ] 
	               
Circuit2[]:=
	Graphics[Join[{AbsoluteThickness[1]},
	              DrawXOR[{2.5,{1,2}}],
	              DrawOP["R", {3.5,2}],
	              {Line[{{3,1}, {4,1}}]}
	             ] 
	        ]
	       
Circuit3[]:=
	Graphics[Join[{AbsoluteThickness[1]},
	              DrawXOR[{5.5,{0,1}}],
	              DrawOP["S", {5.5,2}],
	              DrawXOR[{6.5,{2,0}}],
	              DrawOP["S", {7.5,2}],
	              DrawOP["T", {7.5,0}],
	              DrawXOR[{8.5,{2,0}}],
	              {Line[{{6,1},{9,1}}]}
	             ] 
	        ]
	        
AliceCircuit[]:=
	Show[Circuit1[], Circuit2[],
	     Graphics[{AbsoluteThickness[1], 
	               Line[{{0,2},{3,2}}], Line[{{2,0},{4,0}}]}],
	     AspectRatio->Automatic]
	     
BobCircuit[]:=
	Show[Circuit3[],
	     AspectRatio->Automatic]
	     
	  
(*
:[font = input; initialization; preserveAspect]
*)
AliceCreatesEbit[]:=
	Show[Circuit1[],
	     Graphics[{Text[FontForm["|0>", {"Symbol",10}], {-0.25,0}, {-1,0}],
	               Text[FontForm["|0>", {"Symbol",10}], {-0.25,1}, {-1,0}],
	               Text[FontForm["s", {"Symbol",10}], {2.07,1}, {-1,0}],
	               Text[FontForm["r", {"Symbol",10}], {2.07,0}, {-1,0}]
	              }],
	     AspectRatio->Automatic]
(*
:[font = input; initialization; preserveAspect]
*)
AliceEntanglesEbitWithUnknownState[]:=
	Show[Circuit1[],
	     Circuit2[],
	     Graphics[{Text[FontForm["|y>", {"Symbol",10}], {-0.25,2}, {-1,0}],
	               Text[FontForm["|0>", {"Symbol",10}], {-0.25,0}, {-1,0}],
	               Text[FontForm["|0>", {"Symbol",10}], {-0.25,1}, {-1,0}]}],
	     AspectRatio->Automatic]
(*
:[font = input; preserveAspect]
DrawTeleportationCircuit[]:=
	Show[Circuit1[],
	     Circuit2[],
	     Graphics[{Text[FontForm["|y>", {"Symbol",10}], {-.5,2}, {-1,0}],
	               Text[FontForm["|0>", {"Symbol",10}], {-.5,0}, {-1,0}],
	               Text[FontForm["|0>", {"Symbol",10}], {-.5,1}, {-1,0}]}],
	     Graphics[{Text[FontForm["r", {"Symbol",10}], {4.1,0.2}, {-1,0}],
	               Text[FontForm["s", {"Symbol",10}], {2,1.2}],
	               Text[FontForm["?", {"Symbol",10}], {4.1,1}, {-1,0}],
	               Text[FontForm["?", {"Symbol",10}], {4.1,2}, {-1,0}],
	               AbsoluteThickness[1], Line[{{2,0},{5,0}}],
	               Line[{{0,2},{2,2}}]
	              }],
	     Circuit3[],
	     Graphics[{Text[FontForm["|f>", {"Symbol",10}], {9.1,2}, {-1,0}],
	               Text[FontForm["|f>", {"Symbol",10}], {9.1,1}, {-1,0}],
	               Text[FontForm["|y>", {"Symbol",10}], {9.1,0}, {-1,0}]}],
	     AliceBox[],
	     BobBox[],
	     AspectRatio->Automatic,
	     PlotRange->{{-0.5, 9.6},{-0.7, 2.4}}]
:[font = input; preserveAspect]
AliceBox[]:=
	Graphics[{AbsoluteThickness[1], Dashing[{0.01,0.01}],
	          Line[{{0.125, -0.375},{0.125,2.375},{3.875,2.375},
	                {3.875,-0.375},{0.125, -0.375}}
	              ],
	          Text["Alice", {2,-0.6}]
	         }]
	         
BobBox[]:=
	Graphics[{AbsoluteThickness[1], Dashing[{0.01,0.01}],
	          Line[{{5.125, -0.375},{5.125,2.375},{8.875,2.375},
	                {8.875,-0.375},{5.125, -0.375}}
	              ],
	          Text["Bob", {7,-0.6}]
	         }]
:[font = input; initialization; preserveAspect]
*)
DrawOP[label_String, {x_, y_}]:=
	{Line[{{x-0.25,y-0.25},
	       {x-0.25,y+0.25},
	       {x+0.25,y+0.25},
	       {x+0.25,y-0.25},
	       {x-0.25,y-0.25}}],
	 Text[FontForm[label,{"Courier",12}], {x,y}],
	 Line[{{x-0.5,  y}, {x-0.25,y}}],
	 Line[{{x+0.25, y}, {x+0.5, y}}]
	}

DrawXOR[{x_, {y1_, y2_}}]:=
	Module[{r},
		r = 0.2;
		{Circle[{x,y1}, r],
	     AbsolutePointSize[6],
	     Point[{x,y2}],
	     Line[{{x,If[y1<y2,y1-r,y1+r]}, {x,y2}}],
	     Line[{{x-0.5,y1},{x+0.5,y1}}],
	     Line[{{x-0.5,y2},{x+0.5,y2}}]
	    }
	]
	 
(*
:[font = input; preserveAspect; endGroup]
DrawOP[{x_, y_}, text_String]:=
	Graphics[Line[{{x-0.5, y-0.5},
	               {x+0.5, y-0.5},
	               {x+0.5, y+0.5},
	               {x-0.5, y+0.5},
	               {x-0.5, y-0.5}}], Text[text, {x,y}]]
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Ancillary code in here ...
:[font = subsubsection; inactive; preserveAspect; startGroup]
Controlled-NOT Gate
:[font = input; initialization; preserveAspect]
*)
aOP = {{0,1},   (* annihilation operator on a single bit *)
       {0,0}};
       
annihilationOP[i_, m_]:=
	Apply[Direct,
	      ReplacePart[Table[IdentityMatrix[2], {m}], aOP, i]
	     ]
(*
:[font = input; initialization; preserveAspect]
*)
cOP = {{0,0},     (* creation operator that acts on a single bit *)
       {1,0}};

creationOP[i_, m_]:=
	Apply[Direct,
	      ReplacePart[Table[IdentityMatrix[2], {m}], cOP, i]
	     ]
	
(*
:[font = input; initialization; preserveAspect; endGroup]
*)
CNGate[i_, j_, m_]:=
	(creationOP[i,m] .
	 annihilationOP[i,m] . (annihilationOP[j,m] + creationOP[j,m]) +
	 annihilationOP[i,m] . creationOP[i,m]
	)
(*
:[font = subsection; inactive; preserveAspect; startGroup]
State Vectors
:[font = subsubsection; inactive; preserveAspect; startGroup]
Converting Kets to Column Vectors
:[font = input; initialization; preserveAspect; endGroup]
*)
KetToColumnVector[ket[0]]:={{1},{0}}      (* spin up   = 0 *)
KetToColumnVector[ket[1]]:={{0},{1}}      (* spin down = 1 *)
KetToColumnVector[ket[bits__]]:=
	Apply[Direct, Map[KetToColumnVector[ket[#]]&, {bits}]]

KetToColumnVector[a_ ket_ket]:=
	a KetToColumnVector[ket]
	
KetToColumnVector[Plus[ket_, kets___]]:=
	Apply[Plus, Map[KetToColumnVector, {ket, kets}]]
	
KetToColumnVector[superposition_]:=
	KetToColumnVector[ Expand[superposition] ] 
(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
Converting Bras to Row Vectors
:[font = input; initialization; preserveAspect; endGroup]
*)
BraToRowVector[bra[0]]:={{1,0}}
BraToRowVector[bra[1]]:={{0,1}}
BraToRowVector[w_. bra[bits__]]:=
	w * Apply[Direct, Map[BraToRowVector[bra[#]]&, {bits}]]
BraToRowVector[w_. bra[bits__] + bras_.]:=
	BraToRowVector[w * bra[bits]] + BraToRowVector[bras]
BraToRowVector[superposition_]:=
	BraToRowVector[Expand[superposition]]
(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
Converting Column Vectors to Kets
:[font = input; initialization; preserveAspect; endGroup]
*)
ColumnVectorToKet[amplitudes_]:=
	Apply[Plus,
		  MapThread[(#1[[1]] #2)&,
		            {amplitudes,
		             EigenKets[ Length[amplitudes] ]
		            }
		           ]
		 ]
(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
Converting Row Vectors To Bras
:[font = input; initialization; preserveAspect; endGroup]
*)
RowVectorToBra[{{wi__}}]:=
	Module[{eigenBras},
		eigenBras = EigenKets[Length[{wi}]] /. ket->bra;
		Apply[Plus, MapThread[(#1 #2)&, {{wi}, eigenBras}]]
	]
(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
Converting Between Bras and Kets
:[font = input; initialization; preserveAspect; endGroup]
*)
KetToBra[ket_]:=
	RowVectorToBra[Conjugate[Transpose[KetToColumnVector[ket]]]]

BraToKet[bra_]:=
	ColumnVectorToKet[Conjugate[Transpose[BraToRowVector[bra]]]]
(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
Average Value of an Observable
:[font = input; initialization; preserveAspect; endGroup]
*)
ExpectationValue[w_. ket[bits__] + kets_., observable_]:=
	(If[!HermitianQ[observable], 
		(Message[ExpectationValue::notHermitian]; Abort[]),
		If[Length[observable] != 2^Length[{bits}],
		   (Message[ExpectationValue::incompatible]; Abort[])]];
		       
	 (BraToRowVector[KetToBra[w * ket[bits] + kets]] . 
	  observable . 
	  KetToColumnVector[w * ket[bits] + kets]
	 )[[1,1]]  (* scalar = a 1 x 1 matrix, [[1,1]] removes the parentheses *)
	)

ExpectationValue[superposition_, observable_]:=
	ExpectationValue[Expand[superposition], observable]

ExpectationValue::notHermitian =
	"Your purported observable is not an Hermitian matrix.";
ExpectationValue::incompatible =
	"The dimensions of the state vector and observable are incompatible.";

(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
Creating Eigenstates that Span a Hilbert Space
:[font = input; initialization; preserveAspect]
*)
BasisEigenstates[m_Integer]:= EigenKets[2^m]

BasisEigenstates::usage = 
  "BasisEigenstates[m] returns the complete set of \
  eigenstates that span the Hilbert space of an m-bit \
  quantum memory register.";
(*
:[font = input; initialization; preserveAspect; endGroup]
*)
EigenKets[n_]:=
	Module[{bits},
		bits = Table[Apply[ket, IntegerDigits[i,2]], 
		             {i, 0, n-1}];
		          (* last eigenket has the most bits *)
		Map[PadTo[Length[Last[bits]], #]&, bits]
	]

PadTo[nDigits_, digits_]:=
	Join[Apply[ket, Table[0,{nDigits - Length[digits]}]], 
	     digits]
(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
Accessing Amplitudes of Superpositions and Computing Probabilities
:[font = input; initialization; preserveAspect; startGroup]
*)
Options[Amplitudes] = {ShowEigenstates->False};

ShowEigenstates::usage = 
	"ShowEigenstates is an option for Amplitudes that \
	determines whether the 
output should be a list of the \
	amplitudes or a list of {eigenstate, 
amplitude} pairs.";

Amplitudes[w_. ket[bits__] + kets_., opts___]:=
	Module[{showeigen},
	showeigen = ShowEigenstates /. {opts} /. Options[Amplitudes];
	Which[showeigen == True, 
			Map[{#, Coefficient[w ket[bits] + kets, #]}&,
		        BasisEigenstates[ Length[{bits}] ]
		       ],
		  showeigen == False,
		    Map[Coefficient[w ket[bits] + kets, #]&,
		        BasisEigenstates[ Length[{bits}] ]
		       ]
		  ]
	]

(* This clause catches cases like 1/Sqrt[2] (ket[0] + ket[1]) etc *)	
Amplitudes[c_ (w_. ket[bits__] + kets_.)]:=
	Amplitudes[ Expand[c (w ket[bits] + kets)] ]

Amplitudes::usage = 
  "Amplitudes[superposition] returns the amplitudes of the \
  eigenstates in a superposition or ket vectors.";
(*
:[font = message; inactive; preserveAspect; endGroup]
General::spell1: 
   Possible spelling error: new symbol name "Amplitudes"
     is similar to existing symbol "amplitudes".
:[font = input; initialization; preserveAspect]
*)
Options[Probabilities] = {ShowEigenstates->False};

Probabilities[w_. ket[bits__] + kets_., opts___]:=
	Module[{showeigen, amplitudes, symbols, sumOfSquares},
		showeigen    = ShowEigenstates /. {opts} /. Options[Probabilities];
		amplitudes   = Amplitudes[w ket[bits] + kets];
		symbols      = SymbolicCoefficients[amplitudes]; (*see below*)
		sumOfSquares = Simplify[
		                Apply[Plus, 
		                      Map[ComplexExpand[Abs[#]^2, symbols]&, 
		                          amplitudes]]];
		amplitudes   = If[sumOfSquares=!=1,  (* renormalize amplitudes
		                                         if necessary *)
		                  amplitudes/Sqrt[sumOfSquares],
		                  amplitudes];
		Which[showeigen == True,  
		       MapThread[{#1, ComplexExpand[Abs[#2]^2, symbols]}&, 
		                 {BasisEigenstates[Length[{bits}]], amplitudes}
		                ],
			  showeigen == False, 
			   Map[ComplexExpand[Abs[#]^2, symbols]&, amplitudes]
	    ]
	]

Probabilities[c_ (w_. ket[bits__] + kets_.)]:=
	Probabilities[ Expand[c (w ket[bits] + kets)] ]

Probabilities::usage =
	"Probabilities[superposition] returns the probabilities of \
	 finding a system in a state described by superposition in \
	 each of its possible eigenstates upon being measured (observed). \
	 If Probabilities is given the option ShowEigenstates->True \
	 the function returns a list of {eigenstate, probability} pairs.";
(*
:[font = input; initialization; preserveAspect; endGroup]
*)
SymbolicCoefficients[amplitudes_List]:=
	Select[Union[Flatten[Map[Variables, amplitudes]]], 
		   Not[MatchQ[#, Abs[_]]]&]
(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
Testing Whether a Ket is Properly Normalized
:[font = input; initialization; preserveAspect; endGroup]
*)
Needs["Algebra`ReIm`"];

NormalizedKetQ[ket_]:=
	Module[{columnVector},
		columnVector = KetToColumnVector[ket];
		(Inner[Times, 
		       Conjugate[Transpose[columnVector]], 
               columnVector,
               Plus
              ] == {{1}} // N ) /. z_ Conjugate[z_] :> Abs[z]^2
    ]
   
NormalizedKetQ::usage =
	"NormalizedKetQ[ket] returns True if the square \
	moduli of the amplitudes of the eigenkets in the \
	superposition \"ket\" sum to 1. If \"ket\" has non-numeric \
	amplitudes, the normalization cannot always be determined.";
(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
NormalizeKet
:[font = input; initialization; preserveAspect; endGroup]
*)
NormalizeKet[superposition_]:=
	superposition /; NormalizedKetQ[superposition]
NormalizeKet[superposition_]:=
	Expand[superposition / 
	       Sqrt[Apply[Plus, 
	                  Map[Abs[#]^2&, 
	                      Amplitudes[superposition, 
	                                 ShowEigenstates->False]
	                     ]
	                 ]
	           ]
	]
	      
NormalizeKet::usage =
	"NormalizeKet[superposition] is used to normalize a given \
	superposition of
 ket vectors. That is, if the sum of the squares \
	of the absolute values of 
the amplitudes of the eigenstates in \
	the superposition do not sum to 1, 
NormalizeKet rescales the \
	amplitudes so that they squared moduli will sum 
to 1.";
(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
Direct Product
:[font = input; initialization; preserveAspect; endGroup]
*)
(* Last modified 09/07/96 *)
Needs["LinearAlgebra`MatrixManipulation`"];

Direct[op1_, op2_]:=
	BlockMatrix[Outer[Times, op1, op2]] /; MatrixQ[op1] && MatrixQ[op2]
	
Direct[ket_, bra_]:=
	Direct[KetToColumnVector[ket], BraToRowVector[bra]] /; IsKetQ[ket] && IsBraQ[
bra]
	
Direct[ket1_, ket2_]:=
	ColumnVectorToKet[
		Direct[KetToColumnVector[ket1],
	           KetToColumnVector[ket2]]
	]/; IsKetQ[ket1] && IsKetQ[ket2]

Direct[bra1_, bra2_]:=
	RowVectorToBra[
		Direct[BraToRowVector[bra1],
			   BraToRowVector[bra2]]
	] /; IsBraQ[bra1] && IsBraQ[bra2]
	
Direct[bra_, ket_]:=
	(Message[Direct::braket];
	 Direct[BraToRowVector[bra], KetToColumnVector[ket]]) /; IsBraQ[bra] && 
IsKetQ[ket]

Direct[bra_, op_]:=
	(Message[Direct::braop];
	 Direct[BraToRowVector[bra], op]) /; IsBraQ[bra] && MatrixQ[op]
	
Direct[op_, bra_]:=
	(Message[Direct::opbra];
	 Direct[op, BraToRowVector[bra]]) /; MatrixQ[op] && IsBraQ[bra]
	
Direct[ket_, op_]:=
	(Message[Direct::ketop];
	 Direct[KetToColumnVector[ket], op]) /; IsKetQ[ket] && MatrixQ[op]
	
Direct[op_, ket_]:=
	(Message[Direct::opket];
	 Direct[op, KetToColumnVector[ket]]) /; MatrixQ[op] && IsKetQ[ket]

Direct[matrices__]:=
	Fold[Direct, First[{matrices}], Rest[{matrices}]]

Direct::braket =
	"Warning - You are taking the DIRECT product of a bra \
	and a ket. This is 
unusual. Perhaps you meant to use \
	the DOT product?";
	
Direct::braop =
	"Warning - You are taking the DIRECT product of a bra \
	with an operator. 
This is unusual. Perhaps you meant to use \
	the DOT product?";
	
Direct::opbra =
	"Warning - You are taking the DIRECT product of an operator \
	with a bra. 
This is unusual. Perhaps you meant to use \
	the DOT product?";

Direct::ketop =
	"Warning - You are taking the DIRECT product of a ket \
	with an operator. 
This is unusual. Perhaps you meant to use \
	the DOT product?";

Direct::opket =
	"Warning - You are taking the DIRECT product of an operator \
	with a ket. 
This is unusual. Perhaps you meant to use \
	the DOT product?";


IsKetQ[w_. ket[__] + kets_.]:= True
IsKetQ[_]:=False
	
IsBraQ[w_. bra[__] + bras_.]:= True
IsBraQ[_]:=False
(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
Truth Table of a Logic Gate
:[font = input; initialization; preserveAspect; endGroup]
*)
TruthTable[gate_]:=
	Module[{n,m},
		{n,m} = Dimensions[gate];
		Which[Not[n==m && IntegerQ[n] && IntegerQ[m]],
		      Message[TruthTable::notsquare]; Abort[],
		      Not[IntegerQ[Log[2, n]]],
		      Message[TruthTable::powerof2]; Abort[]
		     ];
		Map[(# -> ColumnVectorToKet[gate . KetToColumnVector[#]])&, 
		    EigenKets[n]
		   ]  // ColumnForm
	]
	
TruthTable::notsquare = 
  "Your input is not a square matrix and cannot, therefore, represent a \
  
reversible logic gate.";

TruthTable::powerof2 = 
  "Your input is not a matrix of dimensions (2^m) x (2^m) for integer m \
  
and cannot, therefore, represent a reversible logic gate that operates \
  on 
m bits.";
(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
Types of Operators (Matrices)
:[font = input; preserveAspect]
HermitianQ[matrix_]:=
	matrix == Conjugate[Transpose[matrix]]
:[font = input; initialization; preserveAspect; endGroup]
*)
UnitaryQ[matrix_]:=
  Module[{rows, cols},
	{rows, cols} = Dimensions[matrix];
	If[Not[IntegerQ[rows]] || 
	   Not[IntegerQ[cols]] || 
	   rows != cols, Message[UnitaryQ::notsquarematrix]];
	
	   Chop[Simplify[ComplexExpand[Conjugate[Transpose[matrix]]] - 
	                 ComplexExpand[Inverse[matrix]]
	                ]
	       ] == ZeroMatrix[rows, cols]
  ]

UnitaryQ::notsquarematrix =
  "Your input is not a square matrix.";
  
ZeroMatrix[rows_, cols_]:=
	Table[0, {rows}, {cols}]
(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
Tools for Making Test Superpositions
:[font = input; initialization; preserveAspect]
*)
SymbolicSuperposition[m_]:=
	Apply[Plus,
	      MapThread[(#1 #2)&, 
	                {SymbolicAmplitudes[m], BasisEigenstates[m]}]
	]
	
SymbolicSuperposition::usage =
	"SymbolicSuperposition[m] creates a superposition of 2^m \
	eigenstates whose
 amplitudes are uninstantiated symbols. These \
	eigenstates represent the 
possible states of an m-bit memory \
	register of a quantum computer. This 
function is useful for \
	exploring the effects of quantum mechanical 
operations on \
	arbitrary superpositions. Note that the general form does not

	guarentee that the superposition is normalized.";
	
SymbolicAmplitudes[m_]:=
	(Clear[w];
	 Map[ToExpression["w"<>ToString[#]]&, Table[i,{i,0,2^m - 1}]]
	)
(*
:[font = input; initialization; preserveAspect; startGroup]
*)
Options[RandomSuperposition] = {Normalized->True};

RandomSuperposition[m_, opts___]:=
	Module[{normalized},
		normalized = Normalized /. {opts} /. Options[RandomSuperposition];
		superposition = Apply[Plus,
	                          MapThread[(#1 #2)&, 
	                                    {RandomAmplitudes[m],
	                                     BasisEigenstates[m]}
	                                   ]
	                         ];
		Which[normalized==True, NormalizeKet[superposition],
	          normalized==False, superposition
	         ]
	]

RandomSuperposition::usage =
	"RandomSuperposition[m] creates a normalized superposition \
	of 2^m eigenstates whose amplitudes are random complex numbers. \
	These eigenstates represent the possible states of an m-bit \
	memory register of a quantum computer. You can generate an \
	un-normalized superposition by setting the option Normalized->False.";
	
(* You can pick the amplitudes according to whatever distribution
   you like. In the current case we pick random complex numbers
   uniformly from the square in the complex plane bounded by a lower
   left corner at (-1,-I) and an upper right corner at (1,I).
*)
RandomAmplitudes[m_]:=
	Table[Random[Complex, {-1-I, 1+I}], {2^m}]
(*
:[font = message; inactive; preserveAspect; endGroup; endGroup]
General::spell1: 
   Possible spelling error: new symbol name "normalized"
     is similar to existing symbol "Normalized".
:[font = subsubsection; inactive; preserveAspect; startGroup]
Arbitrary State
:[font = input; preserveAspect; endGroup; endGroup]
Options[ArbitraryState] = {Numeric->False};

ArbitraryState[m_, opts___]:=
	Module[{coeffs, numericQ},
		Clear[w];
		numericQ = Numeric /. {opts} /. Options[ArbitraryState];
		Switch[numericQ, 
		        True, RandomSuperposition[m],
		        False, (coeffs = Table[c[i], {i,0,2^m -1}];
		                Apply[Plus, 
		                      MapThread[#1 #2&, 
		                                {coeffs, BasisEigenstates[m]}]]
		               )
		      ]
	]
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
Quantum Memory Registers
:[font = subsubsection; inactive; preserveAspect; startGroup]
ReadMemoryRegister
:[font = input; initialization; preserveAspect; endGroup]
*)
(*====================*)
(* ReadMemoryRegister *)
(*====================*)
(* Given a superposition representing the state of the memory of a
   quantum computer, return the result of measuring the memory.
*)
Options[ReadMemoryRegister] = {TraceProgress->False};

ReadMemoryRegister[w_. ket[bits__] + kets_., opts___]:=
	Module[{nBits, superposition, resultsPerStep, traceQ},
		traceQ = TraceProgress /. {opts} /. Options[ReadMemoryRegister];
		nBits = Length[{bits}]; (* figure out number of bits in memory *)
		superposition = {"BeforeAnyMeasurements", w ket[bits] + kets};
		resultsPerStep = FoldList[MeasureIthBit[#2,#1,nBits]&,
		                          superposition,
		                          Range[nBits]
		                         ];
		Which[traceQ===False, 
		        {Rest[Map[#[[1]]&, resultsPerStep]],  (* results for bits *)
		         Last[resultsPerStep][[2]]            (* projected state *)
		        },
		      traceQ===True,
		        ColumnForm[resultsPerStep] (*list of {results,projectedStates}*)
		     ]
	]
	
ReadMemoryRegister::usage =
	"ReadMemoryRegister[superposition] reads the state of each bit \
	in the memory register. As the i-th and j-th bit measurement \
	operators commute (for any i and j), it does not matter in what \
	order you measure the bits.";
	
(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
MeasureIthBit
:[font = input; initialization; preserveAspect; endGroup]
*)
MeasureIthBit[i_, {_, superposition_}, nBits_]:=
	Module[{p1, zeroOrOne, projectedState},
		p1 = ProbabilityIthBitIs1[i, superposition];
		zeroOrOne = BiasedSelect[{0,1}, {1-p1, p1}];
		projectedState = 
		  SuperpositionWithIthBitFixed[i, zeroOrOne, nBits, superposition];
		{zeroOrOne, projectedState}
	]
		       
KetWithIthBitZeroOrOne[i_, zeroOrOne_, nBits_]:=
	ReplacePart[Apply[ket, Table[_,{nBits}]], zeroOrOne, i]

SuperpositionWithIthBitFixed[_, _, _, w_. ket[bits__]]:=
  NormalizeKet[w ket[bits]]
SuperpositionWithIthBitFixed[i_, zeroOrOne_, nBits_, superposition_]:=
  NormalizeKet[Select[superposition,
		              MatchQ[#, _. KetWithIthBitZeroOrOne[i,zeroOrOne,nBits]
		                    ]&
		             ]
		      ]
(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
ProbabilityIthBitIs1
:[font = input; initialization; preserveAspect; endGroup]
*)
ProbabilityIthBitIs1[i_, w_. ket[bits__]]:=
	If[ket[bits][[i]] == 1, Abs[w]^2, 1-Abs[w]^2]  (* Abs[w]^2 == 1 or 0 only *)
	
ProbabilityIthBitIs1[i_, w_. ket[bits__] + kets_.]:=
	Module[{nBits, terms},
		nBits = Length[{bits}];
		terms = Select[w ket[bits] + kets, 
		               MatchQ[#, _. KetWithIthBit1[i,nBits]]&];
		N[Apply[Plus, Map[Abs[#]^2&, Amplitudes[terms]]]/
		  Apply[Plus, Map[Abs[#]^2&, Amplitudes[w ket[bits] + kets]]]
		 ]
	]
	
ProbabilityIthBitIs1[i_, c_. (w_. ket[bits__] + kets_.)]:=
	ProbabilityIthBitIs1[i, Expand[c (w ket[bits] + kets)]]

ProbabilityIthBitIs1::usage =
	"The state of the memory register of a quantum computer \
	(that is comprised of m 2-state particles) is represented by a \
	superposition 2^m eigenstates. The function \
	ProbabilityIthBitIs1[i, superposition] computes the probability \
	that, upon being measured, the i-th, of the m, bits will be a 1.";
	
KetWithIthBit1[i_, nBits_]:=
	ReplacePart[Apply[ket, Table[_,{nBits}]], 1, i]
(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
BiasedSelect
:[font = input; initialization; preserveAspect; startGroup]
*)
(* The list of probabilities should sum to 1. The call to Partition 
   constructs a set of probability intervals whose width is proportional
   to the probability with which the corresponding element in list 
   is selected.
*)
BiasedSelect[list_, probabilities_]:=
	Module[{random},
		random  = Random[];
		Apply[Part[list, #]&,
		      Flatten[
		       Position[Map[InRangeQ[random, #]&, 
		                    Partition[FoldList[Plus,0,probabilities],2,1]
		                   ],
		                True
		       ]
		      ]
		     ]
	] (* /;CheckProbabilitiesQ[probabilities] *)

BiasedSelect::usage =
	"BiasedSelect[{e1,e2,...,en}, {p1,p2,...,pn}] returns element ei of \
	the first list with probability given in the second list pi.";

BiasedSelect::probabilityLeak =
	"You have a probability leak. The probabilities you specified do \
	not add up to 1.";

BiasedSelect::excess =
	"The probabilities you specified sum to greater than 1.";

CheckProbabilitiesQ[probabilities_]:=
	Module[{psum = Apply[Plus, probabilities]},
		Which[psum<1,  Message[BiasedSelect::probabilityLeak],
		      psum>1,  Message[BiasedSelect::excess],
		      psum==1, True
		     ]
	]
	
InRangeQ[n_, {lb_, 1}]:=   lb <= n <= 1
InRangeQ[n_, {lb_, ub_}]:= lb <= n < ub
(*
:[font = message; inactive; preserveAspect; endGroup; endGroup]
General::spell1: 
   Possible spelling error: new symbol name "random" is similar to existing symbol 
    "Random".
:[font = subsubsection; inactive; preserveAspect; startGroup]
ReadPartOfMemoryRegister
:[font = input; initialization; preserveAspect; endGroup; endGroup; endGroup; endGroup]
*)
(*==========================*)
(* ReadPartOfMemoryRegister *)
(*==========================*)
(* Given a superposition representing the state of the memory of a
   quantum computer, return the result of measuring a specific
   subset of the qubits in the memory.
   
   >>> This function is used in error correcting codes <<<
*)
Options[ReadPartOfMemoryRegister] = {TraceProgress->False};

ReadPartOfMemoryRegister[w_. ket[bits__] + kets_., bitsToRead_, opts___]:=
	Module[{nBits, superposition, resultsPerStep, traceQ},
		traceQ = TraceProgress /. {opts} /. Options[ReadPartOfMemoryRegister];
		nBits = Length[{bits}]; (* figure out number of bits in memory *)
		superposition = {"BeforeAnyMeasurements", w ket[bits] + kets};
		resultsPerStep = FoldList[MeasureIthBit[#2,#1,nBits]&,
		                          superposition,
		                          bitsToRead
		                         ];
		Which[traceQ===False, 
		        {Rest[Map[#[[1]]&, resultsPerStep]],  (* results for bits *)
		         Last[resultsPerStep][[2]]            (* projected state *)
		        },
		      traceQ===True,
		        ColumnForm[resultsPerStep] (*list of {results,projectedStates}*)
		     ]
	]
	
ReadPartOfMemoryRegister::usage =
	"ReadPartOfMemoryRegister[superposition, bitsToRead] reads the state \
	of selected bits in the memory register. As the i-th and j-th bit \
	measurement operators commute (for any i and j), it does not matter \
	in what order you measure the bits.";
(*
^*)
